
rm(list=ls())
library(SpatialExtremes)
library(sptcopula)

#Reading the data
source("read-data.R")


tiemethod<-"random"

#Ranking the data to input to spt.copula.fit
alldata<-apply(alldata,2,rank,ties.method=tiemethod)




#initial vaues
prob<-0.9 # threshold level (p)
xy<-coords
ncores<-10 # set the number of cores.
delta.t<-2 # C_T
delta.s<-quantile(dist(coords),1) # C_S=max-distance

#inital values
 corrmodel<-9 # stable-stable separable model
 # phi_1, phi_2 (per range, psi_1) alpha, beta, gamma (smooth,psi_2)
 init.phi<-c(1.253103e+04 ,9.657023e-01 ,3.843973e-01  ,1)
 mask.phi<-c(TRUE,TRUE,TRUE,FALSE)

#marginal parameters
xi<-1 #
sigma<-1 # GPD(xi,sigma)
init.marg<-c(xi,sigma)
mask.marg<-c(FALSE,FALSE)

 # anisotropic parameters
 alpha.ani<-0
 lambda.ani<-1
 init.aniso<-c(alpha.ani,lambda.ani)
 mask.aniso<-c(FALSE,FALSE)

 # omega (velocity) in the notation of  Huser and Davison 2014
 init.velocity<-c(0, 0)
 mask.velocity<-c(FALSE,FALSE)



fitcp<-spt.copula.fit(ydata=as.matrix(alldata), coords = xy, init.marg=init.marg, init.phi=init.phi, init.aniso=init.aniso, init.velocity=init.velocity,
delta.s= delta.s ,delta.t=delta.t, prob = prob, mask.marg=mask.marg, mask.phi=mask.phi, mask.aniso=mask.aniso, mask.velocity=mask.velocity,ties.method=tiemethod,
ncores = ncores, corrmodel = corrmodel, std.error=TRUE,estimation=TRUE, maxit.NM=10000,maxit.BFGS=0)

#saving estimates and se
save(fitcp,file="NLRR-gaussian.out")





